<?php

namespace App\Http\Controllers;

use App\Models\Development;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DevelopmentController extends Controller
{
    public function index()
    {
        $developments = Development::all();
        $data = ['developments' => $developments];
        return $data;

    }

    public function create(Request $request)
    {

    }

    Public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $request_data = $request->only('name',
                'logo',
                'payment_info_bank',
                'payment_info_additional_info',
                'payment_info_bank_account_holder',
                'payment_info_bank_account_number',
                'payment_info_bank_swift_account',
                'contact_info_address',
                'contact_info_phone',
                'contact_info_email');
            $development = Development::create($request_data);

            if ($file = $request->file('logo'))
            {
                $name = time().'logo.'.$file->clientExtension();
                $file->move('images/developments/'.$development->id.'/',$name);

                $development->logo = $name;
                $development->save();
            }

            DB::commit();
            return $this->respondSuccess('Registro almacenado con exito!');
        }catch(\Exception $e){
            DB::rollBack();
            return $this->respondWentWrong($e);
        }
    }

    public function edit($id)
    {

        $development = Development::find($id);

        $media['logo'] = $development->getLogoInfo();


        $data = [
            'development' => $development,
            'media'=>$media,

        ];

        return $data;
    }

    public function update(Request $request, $id)
    {
        try {
            DB::beginTransaction();
            $development = Development::find($id);
            $data = $request->only('name',
                'logo',
                'payment_info_bank',
                'payment_info_additional_info',
                'payment_info_bank_account_holder',
                'payment_info_bank_account_number',
                'payment_info_bank_swift_account',
                'contact_info_address',
                'contact_info_phone',
                'contact_info_email');

            $development->update($data);

            $logo =  json_decode($request->logo);

            if ( $file = $request->file('logo') )
            {
                $name = time().'logo.'.$file->clientExtension();
                $file->move('images/developments/'.$development->id.'/',$name);
                $development->logo = $name;
            }

            $development->save();
            DB::commit();
            $data = $this->respondSuccess('Actualizado con exito!');

        }catch(Exception $e){
            DB::rollBack();
            $data = $this->respondWentWrong($e);


        }
        return $data;
    }
}
