<?php

namespace App\Http\Controllers;

use App\Models\DevelopmentUser;
use Illuminate\Http\Request;

class DevelopmentUserController extends Controller
{
    public function index()
    {
        return DevelopmentUser::all();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'user_id' => ['required', 'exists:users'],
            'development_id' => ['required', 'exists:developments'],
        ]);

        return DevelopmentUser::create($data);
    }

    public function show(DevelopmentUser $developmentUser)
    {
        return $developmentUser;
    }

    public function update(Request $request, DevelopmentUser $developmentUser)
    {
        $data = $request->validate([
            'user_id' => ['required', 'exists:users'],
            'development_id' => ['required', 'exists:developments'],
        ]);

        $developmentUser->update($data);

        return $developmentUser;
    }

    public function destroy(DevelopmentUser $developmentUser)
    {
        $developmentUser->delete();

        return response()->json();
    }
}
