<?php

namespace App\Http\Controllers;

use App\Imports\PropertiesImport;
use App\Models\Development;
use App\Models\DevelopmentUser;
use App\Models\Property;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class PropertiesController extends Controller
{
    /**
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     */
    public function index()
    {
        $develoment_rights = DevelopmentUser::where('user_id', auth()->user()->id)->select('development_id')->get();
        $developments = Development::whereIn('id', $develoment_rights)->get();

        $properties = [];
        $count = [];
        if(request()->get('development_id'))
        {
            $properties = Property::where('development_id', request()->get('development_id'));
            $properties_all = Property::where('development_id', request()->get('development_id'))->count();
            $properties_available = Property::where('development_id', request()->get('development_id'))->where('status', 'available')->count();
            $properties_hold = Property::where('development_id', request()->get('development_id'))->where('status', 'hold')->count();
            $properties_sold = Property::where('development_id', request()->get('development_id'))->where('status', 'sold')->count();
            $count = ['all' => '('.$properties_all.')', 'available' => '('.$properties_available.')', 'hold' => '('.$properties_hold.')', 'sold'=> '('.$properties_sold.')'];

            if(request()->get('status') && request()->get('status') != 'all')
            {
                $properties->where('status', request()->get('status'));
            }
            $properties = $properties->select('id','level','orientation','number','type','property_type','total_area','exterior','starting_price','status')->get();
        }




        $data = ['count'=> $count,'developments' => $developments, 'properties' => $properties];
        return $data;
    }

    public function create()
    {
        $developments = Development::select('id','name')->get();
        $data = ['developments' => $developments];
        return $data;

    }

    public function store(Request $request)
    {
        try {
            DB::beginTransaction();
            $development_id = $request->development_id;
            $properties = Excel::import(new PropertiesImport($development_id), $request->excel);
            DB::commit();
            return $this->respondSuccess('Importacion exitosa!');
        } catch (\Exception $e) {
            DB::rollBack();
            return $this->respondWentWrong($e);
        }
    }

    public function update(Request $request, $id)
    {
        //dd($request);
        try {
            DB::beginTransaction();
            $property = Property::find($id);
            if($property)
            {
                $property->status = $request->status;
                $property->save();
            }
            DB::commit();
            return $this->respondSuccess('registro actualizado');
        } catch (\Exception $e) {
            DB::rollBack();
            return $this->respondWentWrong($e);
        }
    }
}
