<?php

namespace App\Http\Controllers;

use App\Models\Development;
use App\Models\Property;
use App\Models\User;
use PDF;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class QuotationController extends Controller
{
    public function get($id)
    {
        $user = Auth::user();
        //$user = User::find(1);
        //dd($user);
        $property = Property::find($id);
        $development = Development::find($property->development_id)->first();
//dd($development);
        $pdf = PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true]);
        $pdf->loadView('reports.quotation', ['property' => $property, 'user'=> $user,'development' => $development]);
        return $pdf->download('Cotizacion.pdf');
       // return view('reports.quotation')->with('property', $property)->with('user', $user)->with('development', $development);

    }
}
