<?php

namespace App\Http\Controllers;

use App\Models\Development;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
    public function index(): array
    {
        $users = User::select(['id','name','email','type'])->get();
        $data = ['users' =>$users];
        return $data;
    }

    public function create()
    {
        $developments = Development::select(['id','name'])->get();
        $data = ['developments' => $developments];
        return $data;
    }

    public function store(Request $request): \Illuminate\Http\JsonResponse
    {
        //dd($request);
        try {
            DB::beginTransaction();
            $data = $request->only('name','email','phone','password','type');
            $data['password'] = bcrypt($data['password']);
            $user = User::create($data);
            DB::commit();
            return $this->respondSuccess('Usuario registrado con Exito!');
        }catch(\Exception $e)
        {
            DB::rollBack();
            return $this->respondWentWrong($e);

        }
    }

    public function edit($id): array
    {
        $user = User::find($id)->with('developments')->select('id','name','email','phone','type')->first();
        $developments = Development::select(['id','name'])->get();
        $development_rights = $user->development_rights();

        $data = ['user'=>$user, 'developments' => $development_rights];

        return $data;
    }

    public function update(Request $request, $id)
    {
        try {
            $user = User::find($id);
            DB::beginTransaction();
            $data = $request->only('name','email','password','type');
            $developments_rights = $request->input('development_rights');
//dd($request);
        if(isset($data['password']) || $data['password'] != null)            {
            $data['password'] = bcrypt($data['password']);
            }else{
            unset($data['password']);
        }
            //dd($developments_rights);
            $user->update($data);
            $user->developmentsSyncRights($developments_rights);
            DB::commit();
            return $this->respondSuccess('Usuario Actualizado con Exito!');
        }catch(\Exception $e)
        {
            DB::rollBack();
            return $this->respondWentWrong($e);

        }
    }

    public function getUser()
    {
        try
        {
            $user = Auth::user();
            $data = ['user' => $user];
            return $data;
        }catch(\Exception $e)
        {
            return $this->respondWentWrong($e);
        }
    }
}
