<?php

namespace App\Imports;

use App\Models\Property;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithUpserts;

class PropertiesImport implements ToModel, WithHeadingRow,WithUpserts
{
    private $development_id;
    public function __construct($dev_id)
    {
        $this->development_id = $dev_id;
    }



    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {

        return Property::updateOrCreate(['number' => $row['numero'],'development_id'=> $this->development_id],[
            'development_id'=> $this->development_id,
            'level' => $row['nivel'],
            'orientation' => $row['orientacion'],
            'number' => $row['numero'],
            'type' => $row['tipo'],
            'property_type' => $row['tipodpto'],
            'exterior'=>$row['exterior'],
            'indoor_area' => $row['areainterior'],
            'outdoor_area' => $row['areaexterior'],
            'total_area' => $row['areatotal'],
            'starting_price' => $row['precioinicial'],
            'starting_price_m2'=> $row['precioinicialm2'],
            'mortgage5_price'=> $row['preciohipoteca5'],
            'mortgage5_price_m2'=> $row['preciohipoteca5m2'],
            'mortgage5_saving'=> $row['ahorrohipoteca5'],
            'mortgage5_initial_payment_percent'=> $row['porcentajeenganchehipoteca5'],
            'mortgage5_initial_payment_amount'=> $row['importeenganchehipoteca5'],
            'mortgage5_construction_payment_percent'=> $row['porcentajeobrahipoteca5'],
            'mortgage5_construction_payment_amount'=> $row['importeobrahipoteca5'],
            'mortgage5_quantity_payments'=> $row['numeromenhimpoteca5'],
            'mortgage5_amount_payment'=> $row['montomenhipoteca5'],
            'mortgage5_final_payment_percent'=> $row['porcentajeentregahipoteca5'],
            'mortgage5_final_payment_amount'=> $row['montoentregahipoteca5'],

            'mortgage10_price'=> $row['preciohipoteca10'],
            'mortgage10_price_m2'=> $row['preciohipoteca10m2'],
            'mortgage10_saving'=> $row['ahorrohipoteca10'],
            'mortgage10_initial_payment_percent'=> $row['porcentajeenganchehipoteca10'],
            'mortgage10_initial_payment_amount'=> $row['importeenganchehipoteca10'],
            'mortgage10_construction_payment_percent'=> $row['porcentajeobrahipoteca10'],
            'mortgage10_construction_payment_amount'=> $row['importeobrahipoteca10'],
            'mortgage10_quantity_payments'=> $row['numeromenhipoteca10'],
            'mortgage10_amount_payment'=> $row['montomenhipoteca10'],
            'mortgage10_final_payment_percent'=> $row['porcentajeentregahipoteca10'],
            'mortgage10_final_payment_amount'=> $row['montoentregahipoteca10'],

            'cash_price'=> $row['preciocontado'],
            'cash_price_m2'=> $row['preciocontadom2'],
            'cash_saving'=> $row['ahorrocontado'],
            'cash_initial_payment'=> $row['apartadocontado'],
            'cash_credit_info'=> $row['creditoinfo'],
            'zero_price' => $row['precioceromensualidades'],
            'zero_saving' => $row['ahorroceromensualidades'],
            'zero_initial_payment_percent' => $row['porcentajeengancheceromensualidades'],
            'zero_initial_payment_amount' => $row['importeengancheceromensualidades'],
            'zero_final_payment_percent' => $row['porcentajeentregaceromensualidades'],
            'zero_final_payment_amount' => $row['montoentregaceromensualidades'],


            'feature1'=> $row['detalle1'],
            'feature2'=> $row['detalle2'],
            'feature3'=> $row['detalle3'],
            'feature4'=> $row['detalle4'],
            'feature5'=> $row['detalle5'],
            'feature6'=> $row['detalle6'],
            'feature7'=> $row['detalle7'],
            'feature8'=> $row['detalle8'],
            'feature9'=> $row['detalle9'],
            'feature10'=> $row['detalle10'],
        ]);
    }


    public function uniqueBy(): string
    {
        return 'number';
    }
}
