<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Development extends Model
{
    use HasFactory;
    protected $fillable = ['name',
        'logo',
        'payment_info_bank',
        'payment_info_additional_info',
        'payment_info_bank_account_holder',
        'payment_info_bank_account_number',
        'payment_info_bank_swift_account',
        'contact_info_address',
        'contact_info_phone',
        'contact_info_email',
        ];

    public function properties(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(Property::class);
    }

    public function getLogoInfo(): array
    {
        $logo = [];
        if($this->logo){
            $logo = [
                'name'=> $this->logo ,
                'url'=> asset('images/developments/'.$this->id.'/'.$this->logo)
            ];
        }

        return $logo;
    }
}
