<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Property extends Model
{
    use HasFactory;

    protected $fillable = [
        'development_id',
        'level',
        'orientation',
        'number',
        'type',
        'property_type',
        'exterior',
        'indoor_area',
        'outdoor_area',
        'total_area',
        'starting_price',
        'starting_price_m2',
        'mortgage5_price',
        'mortgage5_price_m2',
        'mortgage5_saving',
        'mortgage5_initial_payment_percent',
        'mortgage5_initial_payment_amount',
        'mortgage5_construction_payment_percent',
        'mortgage5_construction_payment_amount',
        'mortgage5_quantity_payments',
        'mortgage5_amount_payment',
        'mortgage5_final_payment_percent',
        'mortgage5_final_payment_amount',
        'mortgage10_price',
        'mortgage10_price_m2',
        'mortgage10_saving',
        'mortgage10_construction_payment_percent',
        'mortgage10_final_payment_percent',
        'mortgage10_final_payment_amount',
        'mortgage10_construction_payment_amount',
        'mortgage10_quantity_payments',
        'mortgage10_amount_payment',
        'mortgage10_initial_payment_percent',
        'mortgage10_initial_payment_amount',
        'cash_price',
        'cash_price_m2',
        'cash_saving',
        'cash_initial_payment',
        'cash_credit_info',
        'scheme_name',
        'scheme_price',
        'scheme_price_m2',

        'zero_price',
        'zero_saving',
        'zero_initial_payment_percent',
        'zero_initial_payment_amount',
        'zero_final_payment_percent',
        'zero_final_payment_amount',

        'feature1',
        'feature2',
        'feature3',
        'feature4',
        'feature5',
        'feature6',
        'feature7',
        'feature8',
        'feature9',
        'feature10',
        'status',
    ];
}
