<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'phone',
        'password',
        'type',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function developments(): \Illuminate\Database\Eloquent\Relations\BelongsToMany
    {
        return $this->belongsToMany(Development::class);
    }

    public function development_rights(): array
    {
        $developments = Development::select('id','name')->get();
        $allowed_developments = DevelopmentUser::where('user_id', $this->id)->get();
        $development_rights = [];

        foreach ($developments as $development) {
            $development->allowed = 0;
           foreach ($allowed_developments as $allowed_development) {
               if ($allowed_development && $allowed_development->development_id == $development->id) {
                   $development->allowed = 1;
               }
           }

            $development_rights[] = $development;

        }
        return $development_rights;
    }

    public function developmentsSyncRights($development_rights)
    {
        DevelopmentUser::where('user_id', $this->id)->delete();
        //dd($development_rights);
        foreach($development_rights as $development_right) {
            if ($development_right['allowed'] === 1 || $development_right['allowed'] === true) {
                DevelopmentUser::create(['user_id'=> $this->id, 'development_id' => $development_right['id']]);
                }
            }
    }


}
