<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDevelopmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('developments', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('logo')->nullable();
            $table->string('payment_info_bank')->nullable();
            $table->string('payment_info_additional_info')->nullable();
            $table->string('payment_info_bank_account_holder')->nullable();
            $table->string('payment_info_bank_account_number')->nullable();
            $table->string('payment_info_bank_swift_account')->nullable();
            $table->string('contact_info_address')->nullable();
            $table->string('contact_info_phone')->nullable();
            $table->string('contact_info_email')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('developments');
    }
}
