<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePropertiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('properties', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('development_id')->nullable()->index();
            $table->string('level')->nullable();
            $table->string('orientation')->nullable();
            $table->string('number')->nullable();
            $table->string('type')->nullable();
            $table->string('property_type')->nullable();
            $table->string('exterior')->nullable();
            $table->decimal('indoor_area',5,2)->default(0.0);
            $table->decimal('outdoor_area',5,2)->default(0.0);
            $table->decimal('total_area',5,2)->default(0.0);
            $table->decimal('starting_price',10,2)->default(0.0);
            $table->decimal('starting_price_m2',10,2)->default(0.0);
            $table->decimal('mortgage_price',10,2)->default(0.0);
            $table->decimal('mortgage_price_m2',10,2)->default(0.0);
            $table->decimal('monthly_price',10,2)->default(0.0);
            $table->decimal('monthly_price_m2',10,2)->default(0.0);
            $table->decimal('counted_price',10,2)->default(0.0);
            $table->decimal('counted_price_m2',10,2)->default(0.0);
            $table->string('scheme_name')->nullable();
            $table->decimal('scheme_price',10,2)->default(0.0);
            $table->decimal('scheme_price_m2',10,2)->default(0.0);
            $table->enum('status', ['available', 'hold','sold', 'released'])->default('available');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('properties');
    }
}
