<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdatePropertiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('properties', function (Blueprint $table) {
            $table->string('feature1')->nullable()->after('scheme_price_m2');
            $table->string('feature2')->nullable()->after('feature1');
            $table->string('feature3')->nullable()->after('feature2');
            $table->string('feature4')->nullable()->after('feature3');
            $table->string('feature5')->nullable()->after('feature4');
            $table->string('feature6')->nullable()->after('feature5');
            $table->string('feature7')->nullable()->after('feature6');
            $table->string('feature8')->nullable()->after('feature7');
            $table->string('feature9')->nullable()->after('feature8');
            $table->string('feature10')->nullable()->after('feature9');

            // Precios de contado

            $table->decimal('cash_saving',10,2)->default(0.0)->after('cash_price_m2');
            $table->decimal('cash_initial_payment',10,2)->default(0.0)->after('cash_saving');
            $table->decimal('cash_credit_info',10,2)->default(0.0)->after('cash_initial_payment');

            // Precios Mensualidad

            $table->decimal('monthly_saving',10,2)->default(0.0)->after('monthly_price_m2');
            $table->decimal('monthly_initial_payment',10,2)->default(0.0)->after('monthly_saving');
            $table->decimal('monthly_construction_payment',10,2)->default(0.0)->after('monthly_saving');
            $table->integer('monthly_quantity_payments')->default(0)->after('monthly_construction_payment');
            $table->decimal('monthly_amount_payment',10,2)->default(0.0)->after('monthly_quantity_payments');

            // Precios Hipoteca

            $table->decimal('mortgage_saving',10,2)->default(0.0)->after('mortgage_price_m2');
            $table->integer('mortgage_initial_payment_percent')->default(0)->after('mortgage_saving');
            $table->decimal('mortgage_initial_payment_amount',10,2)->default(0.0)->after('mortgage_initial_payment_percent');
            $table->integer('mortgage_construction_payment_percent')->default(0)->after('mortgage_initial_payment_amount');
            $table->decimal('mortgage_construction_payment_amount',10,2)->default(0.0)->after('mortgage_construction_payment_percent');
            $table->integer('mortgage_quantity_payments')->default(0)->after('mortgage_construction_payment_amount');
            $table->decimal('mortgage_amount_payment',10,2)->default(0.0)->after('mortgage_quantity_payments');
            $table->integer('mortgage_final_payment_percent')->default(0)->after('mortgage_amount_payment');
            $table->decimal('mortgage_final_payment_amount',10,2)->default(0.0)->after('mortgage_final_payment_percent');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
