"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parse = parse;
exports.genStyles = genStyles;
exports.genVariations = genVariations;
exports.lighten = lighten;
exports.darken = darken;

var _helpers = require("../../util/helpers");

var _colorUtils = require("../../util/colorUtils");

var sRGB = _interopRequireWildcard(require("../../util/color/transformSRGB"));

var LAB = _interopRequireWildcard(require("../../util/color/transformCIELAB"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function parse(theme) {
  var isItem = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var variations = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

  var anchor = theme.anchor,
      variant = _objectWithoutProperties(theme, ["anchor"]);

  var colors = Object.keys(variant);
  var parsedTheme = {};

  for (var i = 0; i < colors.length; ++i) {
    var name = colors[i];
    var value = theme[name];
    if (value == null) continue;

    if (!variations) {
      parsedTheme[name] = {
        base: (0, _colorUtils.intToHex)((0, _colorUtils.colorToInt)(value))
      };
    } else if (isItem) {
      /* istanbul ignore else */
      if (name === 'base' || name.startsWith('lighten') || name.startsWith('darken')) {
        parsedTheme[name] = (0, _colorUtils.colorToHex)(value);
      }
    } else if (_typeof(value) === 'object') {
      parsedTheme[name] = parse(value, true, variations);
    } else {
      parsedTheme[name] = genVariations(name, (0, _colorUtils.colorToInt)(value));
    }
  }

  if (!isItem) {
    parsedTheme.anchor = anchor || parsedTheme.base || parsedTheme.primary.base;
  }

  return parsedTheme;
}
/**
 * Generate the CSS for a base color (.primary)
 */


var genBaseColor = function genBaseColor(name, value) {
  return "\n.v-application .".concat(name, " {\n  background-color: ").concat(value, " !important;\n  border-color: ").concat(value, " !important;\n}\n.v-application .").concat(name, "--text {\n  color: ").concat(value, " !important;\n  caret-color: ").concat(value, " !important;\n}");
};
/**
 * Generate the CSS for a variant color (.primary.darken-2)
 */


var genVariantColor = function genVariantColor(name, variant, value) {
  var _variant$split = variant.split(/(\d)/, 2),
      _variant$split2 = _slicedToArray(_variant$split, 2),
      type = _variant$split2[0],
      n = _variant$split2[1];

  return "\n.v-application .".concat(name, ".").concat(type, "-").concat(n, " {\n  background-color: ").concat(value, " !important;\n  border-color: ").concat(value, " !important;\n}\n.v-application .").concat(name, "--text.text--").concat(type, "-").concat(n, " {\n  color: ").concat(value, " !important;\n  caret-color: ").concat(value, " !important;\n}");
};

var genColorVariableName = function genColorVariableName(name) {
  var variant = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'base';
  return "--v-".concat(name, "-").concat(variant);
};

var genColorVariable = function genColorVariable(name) {
  var variant = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'base';
  return "var(".concat(genColorVariableName(name, variant), ")");
};

function genStyles(theme) {
  var cssVar = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  var anchor = theme.anchor,
      variant = _objectWithoutProperties(theme, ["anchor"]);

  var colors = Object.keys(variant);
  if (!colors.length) return '';
  var variablesCss = '';
  var css = '';
  var aColor = cssVar ? genColorVariable('anchor') : anchor;
  css += ".v-application a { color: ".concat(aColor, "; }");
  cssVar && (variablesCss += "  ".concat(genColorVariableName('anchor'), ": ").concat(anchor, ";\n"));

  for (var i = 0; i < colors.length; ++i) {
    var name = colors[i];
    var value = theme[name];
    css += genBaseColor(name, cssVar ? genColorVariable(name) : value.base);
    cssVar && (variablesCss += "  ".concat(genColorVariableName(name), ": ").concat(value.base, ";\n"));
    var variants = (0, _helpers.keys)(value);

    for (var _i2 = 0; _i2 < variants.length; ++_i2) {
      var _variant = variants[_i2];
      var variantValue = value[_variant];
      if (_variant === 'base') continue;
      css += genVariantColor(name, _variant, cssVar ? genColorVariable(name, _variant) : variantValue);
      cssVar && (variablesCss += "  ".concat(genColorVariableName(name, _variant), ": ").concat(variantValue, ";\n"));
    }
  }

  if (cssVar) {
    variablesCss = ":root {\n".concat(variablesCss, "}\n\n");
  }

  return variablesCss + css;
}

function genVariations(name, value) {
  var values = {
    base: (0, _colorUtils.intToHex)(value)
  };

  for (var i = 5; i > 0; --i) {
    values["lighten".concat(i)] = (0, _colorUtils.intToHex)(lighten(value, i));
  }

  for (var _i3 = 1; _i3 <= 4; ++_i3) {
    values["darken".concat(_i3)] = (0, _colorUtils.intToHex)(darken(value, _i3));
  }

  return values;
}

function lighten(value, amount) {
  var lab = LAB.fromXYZ(sRGB.toXYZ(value));
  lab[0] = lab[0] + amount * 10;
  return sRGB.fromXYZ(LAB.toXYZ(lab));
}

function darken(value, amount) {
  var lab = LAB.fromXYZ(sRGB.toXYZ(value));
  lab[0] = lab[0] - amount * 10;
  return sRGB.fromXYZ(LAB.toXYZ(lab));
}
//# sourceMappingURL=utils.js.map