import Vue from 'vue';
export default Vue.extend({
  name: 'mouse',
  methods: {
    getDefaultMouseEventHandlers(suffix, getEvent) {
      const listeners = Object.keys(this.$listeners).filter(key => key.endsWith(suffix)).reduce((acc, key) => {
        acc[key] = {
          event: key.slice(0, -suffix.length)
        };
        return acc;
      }, {});
      return this.getMouseEventHandlers({ ...listeners,
        ['contextmenu' + suffix]: {
          event: 'contextmenu',
          prevent: true,
          result: false
        }
      }, getEvent);
    },

    getMouseEventHandlers(events, getEvent) {
      const on = {};

      for (const event in events) {
        const eventOptions = events[event];
        if (!this.$listeners[event]) continue; // TODO somehow pull in modifiers

        const prefix = eventOptions.passive ? '&' : (eventOptions.once ? '~' : '') + (eventOptions.capture ? '!' : '');
        const key = prefix + eventOptions.event;

        const handler = e => {
          var _a, _b;

          const mouseEvent = e;

          if (eventOptions.button === undefined || mouseEvent.buttons > 0 && mouseEvent.button === eventOptions.button) {
            if (eventOptions.prevent) {
              e.preventDefault();
            }

            if (eventOptions.stop) {
              e.stopPropagation();
            } // Due to TouchEvent target always returns the element that is first placed
            // Even if touch point has since moved outside the interactive area of that element
            // Ref: https://developer.mozilla.org/en-US/docs/Web/API/Touch/target
            // This block of code aims to make sure touchEvent is always dispatched from the element that is being pointed at


            if (e && 'touches' in e) {
              const classSeparator = ' ';
              const eventTargetClasses = (_a = e.currentTarget) === null || _a === void 0 ? void 0 : _a.className.split(classSeparator);
              const currentTargets = document.elementsFromPoint(e.changedTouches[0].clientX, e.changedTouches[0].clientY); // Get "the same kind" current hovering target by checking
              // If element has the same class of initial touch start element (which has touch event listener registered)

              const currentTarget = currentTargets.find(t => t.className.split(classSeparator).some(c => eventTargetClasses.includes(c)));

              if (currentTarget && !((_b = e.target) === null || _b === void 0 ? void 0 : _b.isSameNode(currentTarget))) {
                currentTarget.dispatchEvent(new TouchEvent(e.type, {
                  changedTouches: e.changedTouches,
                  targetTouches: e.targetTouches,
                  touches: e.touches
                }));
                return;
              }
            }

            this.$emit(event, getEvent(e), e);
          }

          return eventOptions.result;
        };

        if (key in on) {
          /* istanbul ignore next */
          if (Array.isArray(on[key])) {
            on[key].push(handler);
          } else {
            on[key] = [on[key], handler];
          }
        } else {
          on[key] = handler;
        }
      }

      return on;
    }

  }
});
//# sourceMappingURL=mouse.js.map