import Vue from 'vue';
import VueRouter from 'vue-router';
import store from "./Store";
Vue.use(VueRouter);

const adminRouter = new VueRouter({
    //mode: "history",
    routes:[

        {
            name: 'dashboard',
            path: '/',
            component: require('./dashboard/Home').default,

        },
        {
            name: 'developments',
            path: '/developments',
            component: require('./developments/List').default,

        },

        {
            name: 'developments.create',
            path: '/developments/create',
            component: require('./developments/Edit').default,

        },

        {
            name: 'developments.create',
            path: '/developments/edit/:id',
            component: require('./developments/Edit').default,

        },

        {
            name: 'users',
            path: '/users',
            component: require('./users/List').default,


        },

        {
            name: 'users.create',
            path: '/users/create',
            component: require('./users/Edit').default,


        },

        {
            name:'users.edit',
            path:'/users/edit/:id',
            component: require('./users/Edit').default,


        },

        {
            name:'import',
            path:'/properties/import',
            component: require('./properties/Import').default,


        },


    ],

});
adminRouter.beforeEach((to,from,next) =>{
    store.dispatch('getUser').then(() => {
        if(store.state.user.type === 'admin' && to.name !== 'dashboard') {
            next();
        }else if (to.name == 'dashboard'){
            next();
        }else{
            next({path:'/'});
        }

    });


})

export default adminRouter;
