
import adminRouter from './adminRouter';

require('./Common');
window.Vue = require('vue');
import Vuetify from 'vuetify';
import store from './Store';
import eventBus from './Event';

Vue.use(eventBus);

import 'vuetify/dist/vuetify.min.css';


Vue.use(Vuetify);


const app = new Vue({
    el:'#app',
    vuetify: new Vuetify({
            theme: {
                themes: {
                    light: {
                        primary: '#d06e47',
                        secondary: '#b0bec5',
                        accent: '#8c9eff',
                        error: '#b71c1c',
                    },
                },
            },
        }),

    router: adminRouter,
    eventBus,
    store,

    props: {
        source: String,
    },
    data: () => ({
        drawer: null,
    }),
    created () {
        this.$vuetify.theme.dark = false

    },
    methods:{
        dialogOk() {
            store.commit('dialogOk');
        },
        dialogCancel() {
            store.commit('dialogCancel');
        },
    },
    computed:{
        showSnackbar: {
            get() {
                return store.getters.showSnackbar;
            },
            set(val) {
                if (!val) store.commit('hideSnackbar');
            },
        },
        snackbarMessage() {
            return store.getters.snackbarMessage;
        },
        snackbarColor() {
            return store.getters.snackbarColor;
        },
        snackbarDuration() {
            return store.getters.snackbarDuration;
        },

        // dialog
        showDialog: {
            get() {
                return store.getters.showDialog;
            },
            set(val) {
                if (!val) store.commit('hideDialog');
            },
        },
        dialogType() {
            return store.getters.dialogType;
        },
        dialogTitle() {
            return store.getters.dialogTitle;
        },
        dialogMessage() {
            return store.getters.dialogMessage;
        },
        dialogIcon() {
            return store.getters.dialogIcon;
        },

    },
    mounted(){
        console.log('Mounted');
    }
});

//Vue.component('example-component',require('../components/ExampleComponent.vue').default);
