<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>CADU Inmobiliaria</title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,600" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@5.x/css/materialdesignicons.min.css" rel="stylesheet">
    <link rel='stylesheet' href='https://cdn.jsdelivr.net/npm/vuetify@2.3.4/dist/vuetify.min.css'>

    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
</head>
<body>
<div id="app">
    <template>
        <v-app id="inspire">
            <v-navigation-drawer
                v-model="drawer"
                fixed
                app
            >
                <v-list>
                    <v-list-item :to="{name:'dashboard'}" >
                        <v-list-item-action>
                            <v-icon>mdi-home</v-icon>
                        </v-list-item-action>
                        <v-list-item-content>
                            <v-list-item-title>Inicio</v-list-item-title>
                        </v-list-item-content>
                    </v-list-item>
<?php if(Auth::user()->type == 'admin'): ?>
                    <v-list-item :to="{name:'developments'}">
                        <v-list-item-action>
                            <v-icon>mdi-domain</v-icon>
                        </v-list-item-action>
                        <v-list-item-content>
                            <v-list-item-title>Desarrollos </v-list-item-title>
                        </v-list-item-content>
                    </v-list-item>


                    <v-list-item :to="{name:'users'}">
                        <v-list-item-action>
                            <v-icon>mdi-account</v-icon>
                        </v-list-item-action>
                        <v-list-item-content>
                            <v-list-item-title>Usuarios</v-list-item-title>
                        </v-list-item-content>
                    </v-list-item>

                    <v-list-item :to="{name:'import'}">
                        <v-list-item-action>
                            <v-icon>mdi-file-excel</v-icon>
                        </v-list-item-action>
                        <v-list-item-content>
                            <v-list-item-title>Importar Propiedades</v-list-item-title>
                        </v-list-item-content>
                    </v-list-item>
<?php endif; ?>

                </v-list>
                <template v-slot:append>
                    <div class="pa-2">
                        <form action="<?php echo e(route('logout')); ?>" method="post">
                            <?php echo e(csrf_field()); ?>


                            <v-btn block  type="submit">
                                Salir
                            </v-btn>
                        </form>
                    </div>
                </template>

            </v-navigation-drawer>

            <v-app-bar
                app

            >
                <v-app-bar-nav-icon @click.stop="drawer = !drawer"></v-app-bar-nav-icon>
                <v-toolbar-title></v-toolbar-title>
            </v-app-bar>

            <v-main>
                <v-container

                    fluid
                >
                    <v-row
                        align="center"
                        justify="center"
                    >
                        <v-col class="text-center">
                            <router-view></router-view>

                        </v-col>
                    </v-row>
                </v-container>
            </v-main>
            <v-footer
                color="#d06e47"
                app
            >
                <span class="white--text">&copy; <?php echo date("Y"); ?></span>
            </v-footer>
        </v-app>
        <!-- snackbar -->
        <v-snackbar
            v-model="showSnackbar"
            :timeout="snackbarDuration"
            :color="snackbarColor"
            top
            right
        >
            {{ snackbarMessage }}
            <v-icon @click="showSnackbar = false" medium>
                mdi-close
            </v-icon>
        </v-snackbar>

        <!-- dialog confirm -->
        <v-dialog v-show="showDialog" v-model="showDialog" lazy absolute max-width="450px">
            <v-card>
                <v-card-title>
                    <div class="subtitle-1 font-weight-medium">
                        <v-icon v-if="dialogIcon" medium>
                            {{dialogIcon}}
                        </v-icon>
                        {{ dialogTitle }}
                    </div>
                </v-card-title>
                <v-card-text>
                    {{ dialogMessage }}
                </v-card-text>
                <v-card-actions v-if="dialogType=='confirm'">
                    <v-spacer></v-spacer>
                    <v-btn text color="green darken-1"@click.native="dialogCancel">
                        Cancelar
                    </v-btn>
                    <v-btn text color="green darken-1"@click.native="dialogOk">
                        Aceptar
                    </v-btn>
                </v-card-actions>
            </v-card>
        </v-dialog>

    </template>
</div>
</body>
<script src="<?php echo e(asset(mix('js/app.js'))); ?>"></script>
</html>
<?php /**PATH /var/www/html/resources/views/main.blade.php ENDPATH**/ ?>