<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Cotizacion</title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
            border: 1px transparent;
        }
        td{
            border:1px solid transparent;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .gray {
            background-color: lightgray
        }

    </style>
</head>
<body>
<table width="100%">
    <tr><td align="center"><h2>Cotización</h2></td></tr>
</table>

<table width="100%" >
    <tr>
        <td valign="top" width="40%"><img height="100px" src="<?php echo e(asset('images/developments/'.$development->id.'/'.$development->logo)); ?>"/></td>
        <td width="20%"></td>
        <td align="center">
            <h3>OPCIONES DE PAGO</h3>

        </td>

    </tr>
    <tr>
        <td rowspan="3">
            <!-- Tabla precio de lista -->
            <table width="100%" >
                <tr>
                    <td></td>
                    <td></td>
                    <td>Precio de Lista:</td>
                </tr>
                <tr>
                    <td># DEPTO:</td>
                    <td><h2><?php echo e($property->number); ?></h2></td>
                    <td><h2>$ <?php echo e(number_format($property->starting_price,2)); ?></h2></td>
                </tr>
            </table>
            <!-- Termina Tabla precio de lista -->

            <!-- Tabla orientacion -->
            <table width="100%" >
                <tr>
                    <td colspan="4">Orientacion:</td>

                </tr>
                <tr>

                    <td colspan="4"><strong><?php echo e($property->orientation); ?></strong>
                    </td>

                </tr>
                <tr>
                    <td>TIPO:</td>
                    <td><strong><?php echo e($property->type); ?></strong></td>
                    <td>M2 DEPTO:</td>
                    <td><strong><?php echo e($property->indoor_area); ?> M2</strong></td>
                </tr>
                <tr>
                    <td>NIVEL:</td>
                    <td><strong><?php echo e($property->level); ?></strong></td>
                    <td><?php echo e($property->exterior); ?>:</td>
                    <td><strong><?php echo e($property->outdoor_area); ?> M2</strong></td>
                </tr>

                <tr>
                    <td></td>
                    <td><strong></strong></td>
                    <td>SUP TOTAL:</td>
                    <td><strong><?php echo e($property->total_area); ?> M2</strong></td>
                </tr>

                <tr>
                    <?php if(1==2): ?>   <td></td>
                    <td><strong></strong></td>
                    <td>PRECIO POR M2:</td>
                    <td><strong>$<?php echo e(number_format($property->starting_price_m2, 2)); ?> M2</strong></td><?php endif; ?>
                </tr>

            </table>
            <!-- Termina Tabla orientacion -->

            <!-- Tabla features -->
            <table width="100%" >
                <tr>
                    <td><h3>DETALLES DEL DEPTO:</h3></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature1); ?></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature2); ?></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature3); ?></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature4); ?></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature5); ?></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature6); ?></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature7); ?></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature8); ?></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature9); ?></td>
                </tr>
                <tr>
                    <td><?php echo e($property->feature10); ?></td>
                </tr>
            </table>
            <!-- Termina Tabla features -->

            <!-- Tabla informacion bancaria -->
            <table width="100%" >
                <tr>
                    <td><strong>CUENTA PARA DEPOSITAR</strong></td>
                </tr>
                <tr>
                    <td><span><?php echo e($development->payment_info_bank); ?></span></td>
                </tr>
                <tr>
                    <td><span><?php echo e($development->payment_info_additional_info); ?></span></td>
                </tr>
                <tr>
                    <td><span><?php echo e($development->payment_info_bank_account_holder); ?></span></td>
                </tr>
                <tr>
                    <td><small><strong>CUENTA: <?php echo e($development->payment_info_bank_account_number); ?></strong></small></td>
                </tr>
                <tr>
                    <td><small><strong>CLABE: <?php echo e($development->payment_info_bank_swift_account); ?></strong></small></td>
                </tr>
                <tr>
                    <td><small>Pida su referencia con su Asesor.</small></td>
                </tr>
            </table>
            <!-- termina tabla infomacion bancaria -->




        </td>
        <td></td>
        <td rowspan="3">
            <!-- Tabla Cero -->
            <table width="100%">
                <tr>
                    <td colspan="2" align="center" bgcolor="#d3d3d3"><strong>CERO MENSUALIDAD</strong></td>

                </tr>
                <tr>
                    <td>Precio descuento Plan:</td>
                    <td><strong>$<?php echo e(number_format($property->zero_price,2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Total Ahorro:</td>
                    <td><strong>$<?php echo e(number_format($property->zero_saving,2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Enganche (<?php echo e($property->zero_initial_payment_percent); ?>%):</td>
                    <td><strong>$<?php echo e(number_format($property->zero_initial_payment_amount,2)); ?></strong></td>
                </tr>

                <tr>
                    <td>A la entrega (<?php echo e($property->zero_final_payment_percent); ?>%):</td>
                    <td><strong>$<?php echo e(number_format($property->zero_final_payment_amount,2)); ?></strong></td>
                </tr>



            </table>
            <!-- Termina Tabla Cero -->

            <!-- Tabla Hipotecario 5 -->
            <table width="100%">
                <tr>
                    <td colspan="2" align="center" bgcolor="#d3d3d3"><strong>HIPOTECARIO 5</strong></td>

                </tr>
                <tr>
                    <td>Precio descuento Plan:</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage5_price,2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Total Ahorro:</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage5_saving,2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Enganche (<?php echo e($property->mortgage5_initial_payment_percent); ?>%):</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage5_initial_payment_amount,2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Durante la obra (<?php echo e($property->mortgage5_construction_payment_percent); ?>%):</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage5_construction_payment_amount,2)); ?></strong></td>
                </tr>
                <tr>
                    <td><?php echo e($property->mortgage5_quantity_payments); ?> Mensualidades de:</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage5_amount_payment,2)); ?></strong></td>
                </tr>

                <tr>
                    <td>A la entrega (<?php echo e($property->mortgage5_final_payment_percent); ?>%):</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage5_final_payment_amount,2)); ?></strong></td>
                </tr>

                <tr>
                   <?php if(1==2): ?> <td>Valor por M2:</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage5_price_m2,2)); ?></strong></td><?php endif; ?>
                </tr>

            </table>
            <!-- Termina Tabla Hipotecario 5 -->

            <!-- Tabla Hipotecario 10 -->
            <table width="100%">
                <tr>
                    <td colspan="2" align="center" bgcolor="#d3d3d3"><strong>HIPOTECARIO 10</strong></td>

                </tr>
                <tr>
                    <td>Precio descuento Plan:</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage10_price, 2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Total Ahorro:</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage10_saving, 2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Enganche (<?php echo e($property->mortgage10_initial_payment_percent); ?>%):</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage10_initial_payment_amount,2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Durante la obra (<?php echo e($property->mortgage10_construction_payment_percent); ?>%):</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage10_construction_payment_amount,2)); ?></strong></td>
                </tr>
                <tr>
                    <td><?php echo e($property->mortgage10_quantity_payments); ?> Mensualidades de:</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage10_amount_payment,2)); ?></strong></td>
                </tr>

                <tr>
                    <td>A la entrega (<?php echo e($property->mortgage10_final_payment_percent); ?>%):</td>
                    <td><strong>$<?php echo e(number_format($property->mortgage10_final_payment_amount,2)); ?></strong></td>
                </tr>

                <tr>
                    <?php if(1==2): ?>  <td>Valor por M2:</td>
                    <td><strong>$<?php echo e(number_format($property->monthly_price_m2,2)); ?></strong></td><?php endif; ?>
                </tr>

            </table>
            <!-- Termina Tabla Hipotecario 10 -->

            <!-- Tabla Contado -->
            <table width="100%">
                <tr>
                    <td colspan="2" align="center" bgcolor="#d3d3d3"><strong>CONTADO</strong></td>

                </tr>
                <tr>
                    <td>Precio descuento Plan:</td>
                    <td><strong>$<?php echo e(number_format($property->cash_price,2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Total Ahorro:</td>
                    <td><strong>$<?php echo e(number_format($property->cash_saving,2)); ?></strong></td>
                </tr>
                <tr>
                    <td>Apartado:</td>
                    <td><strong>$<?php echo e(number_format($property->cash_initial_payment,2)); ?></strong></td>
                </tr>
                <?php
                    $loan = $property->cash_credit_info;
                    $balance = 0;

                ?>
                <tr>
                    <td>Diferencia:</td>
                    <td><strong>$<?php echo e(number_format($loan,2)); ?></strong></td>
                </tr>
                <?php if(1==2): ?>
                    <tr>
                    <td>Diferencia:</td>
                    <td><strong>$0</strong></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <td>Mensualidades de:</td>
                    <td><strong>$0</strong></td>
                </tr>
                <tr>
                    <?php if(1==2): ?>    <td>Valor por M2:</td>
                    <td><strong>$<?php echo e(number_format($property->cash_price_m2,2)); ?></strong></td><?php endif; ?>
                </tr>

            </table>
            <!-- Termina Tabla Contado -->

            <!-- Tabla informacion vendedor -->
            <table width="100%">
                <tr>
                    <td colspan="2"><strong>DATOS DEL VENDEDOR</strong></td>
                </tr>
                <tr>
                    <td>Nombre:</td>
                    <td><strong><?php echo e($user->name); ?></strong></td>
                </tr>
                <tr>
                    <td>Cel:</td>
                    <td><strong><?php echo e($user->phone); ?></strong></td>
                </tr>
                <tr>
                    <td>E-mail</td>
                    <td><strong><?php echo e($user->email); ?></strong></td>
                </tr>
            </table>
            <!-- termina Tabla informacion vendedor -->


        </td>
    </tr>


    <tr>

        <td></td>

    </tr>
</table>

<br/>

<table width="100%" bgcolor="#d3d3d3" style="color: black">
    <tr><td colspan="2" ><small>Todos los precios mostrados en la presente cotización son estimados.
            Los valores de esta propuesta están sujetos a cambios sin previo aviso.
                Esta Propuesta es valida por 72 horas después de su fecha de elaboración.</small></td>
    </tr>
    <tr>
        <td> <h3>
                CONTACTO:


            </h3></td>
        <td align="right">Fecha de impresion: <strong><?php echo(date('d-m-Y H:i:s')) ?></strong></td>
    </tr>
    <tr>
        <td>
            <h4>

                <?php echo e($development->contact_info_address); ?><br />
                <?php echo e($development->contact_info_email); ?><br />
                <?php echo e($development->contact_info_phone); ?>

            </h4>
        </td>

        <td align="center">


    </tr>
</table>



</body>
</html>
<?php /**PATH /var/www/html/resources/views/reports/quotation.blade.php ENDPATH**/ ?>