<?php //11a1d8c60d4a5cc4bdb50d1aa6990432
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_DevelopmentUser_C;
    use LaravelIdea\Helper\App\Models\_IH_DevelopmentUser_QB;
    use LaravelIdea\Helper\App\Models\_IH_Development_C;
    use LaravelIdea\Helper\App\Models\_IH_Development_QB;
    use LaravelIdea\Helper\App\Models\_IH_Property_C;
    use LaravelIdea\Helper\App\Models\_IH_Property_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    
    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Property_C|Property[] $properties
     * @property-read int $properties_count
     * @method HasMany|_IH_Property_QB properties()
     * @method static _IH_Development_QB onWriteConnection()
     * @method _IH_Development_QB newQuery()
     * @method static _IH_Development_QB on(null|string $connection = null)
     * @method static _IH_Development_QB query()
     * @method static _IH_Development_QB with(array|string $relations)
     * @method _IH_Development_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Development_C|Development[] all()
     * @foreignLinks id,\App\Models\Property,development_id|id,\App\Models\DevelopmentUser,development_id
     * @mixin _IH_Development_QB
     */
    class Development extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $development_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Development $development
     * @method BelongsTo|_IH_Development_QB development()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_DevelopmentUser_QB onWriteConnection()
     * @method _IH_DevelopmentUser_QB newQuery()
     * @method static _IH_DevelopmentUser_QB on(null|string $connection = null)
     * @method static _IH_DevelopmentUser_QB query()
     * @method static _IH_DevelopmentUser_QB with(array|string $relations)
     * @method _IH_DevelopmentUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DevelopmentUser_C|DevelopmentUser[] all()
     * @ownLinks user_id,\App\Models\User,id|development_id,\App\Models\Development,id
     * @mixin _IH_DevelopmentUser_QB
     */
    class DevelopmentUser extends Model {}
    
    /**
     * @property int $id
     * @property int|null $development_id
     * @property string|null $level
     * @property string|null $orientation
     * @property string|null $number
     * @property string|null $type
     * @property string|null $property_type
     * @property string|null $exterior
     * @property float $indoor_area
     * @property float $outdoor_area
     * @property float $total_area
     * @property float $starting_price
     * @property float $starting_price_m2
     * @property string|null $scheme_name
     * @property float $scheme_price
     * @property float $scheme_price_m2
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property float $cash_price
     * @property float $cash_price_m2
     * @property string|null $feature1
     * @property string|null $feature2
     * @property string|null $feature3
     * @property string|null $feature4
     * @property string|null $feature5
     * @property string|null $feature6
     * @property string|null $feature7
     * @property string|null $feature8
     * @property string|null $feature9
     * @property string|null $feature10
     * @property float $cash_saving
     * @property float $cash_initial_payment
     * @property float $cash_credit_info
     * @property float $mortgage5_price
     * @property float $mortgage5_price_m2
     * @property int $mortgage5_quantity_payments
     * @property float $mortgage5_amount_payment
     * @property float $mortgage5_saving
     * @property int $mortgage5_initial_payment_percent
     * @property float $mortgage5_initial_payment_amount
     * @property int $mortgage5_construction_payment_percent
     * @property float $mortgage5_construction_payment_amount
     * @property int $mortgage5_final_payment_percent
     * @property float $mortgage5_final_payment_amount
     * @property float $mortgage10_price
     * @property float $mortgage10_price_m2
     * @property float $mortgage10_initial_payment_amount
     * @property int $mortgage10_quantity_payments
     * @property float $mortgage10_amount_payment
     * @property float $mortgage10_saving
     * @property float $mortgage10_construction_payment_amount
     * @property int $mortgage10_initial_payment_percent
     * @property int $mortgage10_construction_payment_percent
     * @property int $mortgage10_final_payment_percent
     * @property float $mortgage10_final_payment_amount
     * @property float $zero_price
     * @property float $zero_saving
     * @property int $zero_initial_payment_percent
     * @property float $zero_initial_payment_amount
     * @property int $zero_final_payment_percent
     * @property float $zero_final_payment_amount
     * @method static _IH_Property_QB onWriteConnection()
     * @method _IH_Property_QB newQuery()
     * @method static _IH_Property_QB on(null|string $connection = null)
     * @method static _IH_Property_QB query()
     * @method static _IH_Property_QB with(array|string $relations)
     * @method _IH_Property_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Property_C|Property[] all()
     * @ownLinks development_id,\App\Models\Development,id
     * @mixin _IH_Property_QB
     */
    class Property extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property string $password
     * @property string $type
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $phone
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @foreignLinks id,\App\Models\DevelopmentUser,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(...$parameters)
     */
    class User extends Model {}
}